﻿//////////////////////////////////////////////
// IndexFormat.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

// nkMaths
#include <NilkinsMaths/Algebra/Vector.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	enum class INDEX_FORMAT
	{
		UINT8 = 0,
		UINT16,
		UINT32
	} ;

	class DLL_GRAPHICS_EXPORT IndexFormatUtils final
	{
		public :

			// Conversions
			static nkMemory::StringView toString (INDEX_FORMAT value) ;

			// Translation
			static unsigned int getFormatByteSize (INDEX_FORMAT format) ;
	} ;
}